package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetRedisRedisUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetRedisRedisUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  migration: Output[Option[besom.api.aiven.inputs.GetRedisRedisUserConfigMigrationArgs]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GetRedisRedisUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GetRedisRedisUserConfigPrivatelinkAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GetRedisRedisUserConfigPublicAccessArgs]],
  recoveryBasebackupName: Output[Option[String]],
  redisAclChannelsDefault: Output[Option[String]],
  redisIoThreads: Output[Option[Int]],
  redisLfuDecayTime: Output[Option[Int]],
  redisLfuLogFactor: Output[Option[Int]],
  redisMaxmemoryPolicy: Output[Option[String]],
  redisNotifyKeyspaceEvents: Output[Option[String]],
  redisNumberOfDatabases: Output[Option[Int]],
  redisPersistence: Output[Option[String]],
  redisPubsubClientOutputBufferLimit: Output[Option[Int]],
  redisSsl: Output[Option[Boolean]],
  redisTimeout: Output[Option[Int]],
  serviceToForkFrom: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetRedisRedisUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetRedisRedisUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    migration: Input.Optional[besom.api.aiven.inputs.GetRedisRedisUserConfigMigrationArgs] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GetRedisRedisUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GetRedisRedisUserConfigPrivatelinkAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GetRedisRedisUserConfigPublicAccessArgs] = None,
    recoveryBasebackupName: Input.Optional[String] = None,
    redisAclChannelsDefault: Input.Optional[String] = None,
    redisIoThreads: Input.Optional[Int] = None,
    redisLfuDecayTime: Input.Optional[Int] = None,
    redisLfuLogFactor: Input.Optional[Int] = None,
    redisMaxmemoryPolicy: Input.Optional[String] = None,
    redisNotifyKeyspaceEvents: Input.Optional[String] = None,
    redisNumberOfDatabases: Input.Optional[Int] = None,
    redisPersistence: Input.Optional[String] = None,
    redisPubsubClientOutputBufferLimit: Input.Optional[Int] = None,
    redisSsl: Input.Optional[Boolean] = None,
    redisTimeout: Input.Optional[Int] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetRedisRedisUserConfigArgs =
    new GetRedisRedisUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      migration = migration.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      recoveryBasebackupName = recoveryBasebackupName.asOptionOutput(isSecret = false),
      redisAclChannelsDefault = redisAclChannelsDefault.asOptionOutput(isSecret = false),
      redisIoThreads = redisIoThreads.asOptionOutput(isSecret = false),
      redisLfuDecayTime = redisLfuDecayTime.asOptionOutput(isSecret = false),
      redisLfuLogFactor = redisLfuLogFactor.asOptionOutput(isSecret = false),
      redisMaxmemoryPolicy = redisMaxmemoryPolicy.asOptionOutput(isSecret = false),
      redisNotifyKeyspaceEvents = redisNotifyKeyspaceEvents.asOptionOutput(isSecret = false),
      redisNumberOfDatabases = redisNumberOfDatabases.asOptionOutput(isSecret = false),
      redisPersistence = redisPersistence.asOptionOutput(isSecret = false),
      redisPubsubClientOutputBufferLimit = redisPubsubClientOutputBufferLimit.asOptionOutput(isSecret = false),
      redisSsl = redisSsl.asOptionOutput(isSecret = false),
      redisTimeout = redisTimeout.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
