package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetRedisRedisUserConfigPrivateAccessArgs private(
  prometheus: Output[Option[Boolean]],
  redis: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetRedisRedisUserConfigPrivateAccessArgs:
  def apply(
    prometheus: Input.Optional[Boolean] = None,
    redis: Input.Optional[Boolean] = None
  )(using Context): GetRedisRedisUserConfigPrivateAccessArgs =
    new GetRedisRedisUserConfigPrivateAccessArgs(
      prometheus = prometheus.asOptionOutput(isSecret = false),
      redis = redis.asOptionOutput(isSecret = false)
    )
