package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationDatadogUserConfigOpensearchArgs private(
  indexStatsEnabled: Output[Option[Boolean]],
  pendingTaskStatsEnabled: Output[Option[Boolean]],
  pshardStatsEnabled: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationDatadogUserConfigOpensearchArgs:
  def apply(
    indexStatsEnabled: Input.Optional[Boolean] = None,
    pendingTaskStatsEnabled: Input.Optional[Boolean] = None,
    pshardStatsEnabled: Input.Optional[Boolean] = None
  )(using Context): GetServiceIntegrationDatadogUserConfigOpensearchArgs =
    new GetServiceIntegrationDatadogUserConfigOpensearchArgs(
      indexStatsEnabled = indexStatsEnabled.asOptionOutput(isSecret = false),
      pendingTaskStatsEnabled = pendingTaskStatsEnabled.asOptionOutput(isSecret = false),
      pshardStatsEnabled = pshardStatsEnabled.asOptionOutput(isSecret = false)
    )
