package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationEndpointDatadogUserConfigArgs private(
  datadogApiKey: Output[String],
  datadogTags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetServiceIntegrationEndpointDatadogUserConfigDatadogTagArgs]]],
  disableConsumerStats: Output[Option[Boolean]],
  kafkaConsumerCheckInstances: Output[Option[Int]],
  kafkaConsumerStatsTimeout: Output[Option[Int]],
  maxPartitionContexts: Output[Option[Int]],
  site: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationEndpointDatadogUserConfigArgs:
  def apply(
    datadogApiKey: Input[String],
    datadogTags: Input.Optional[List[Input[besom.api.aiven.inputs.GetServiceIntegrationEndpointDatadogUserConfigDatadogTagArgs]]] = None,
    disableConsumerStats: Input.Optional[Boolean] = None,
    kafkaConsumerCheckInstances: Input.Optional[Int] = None,
    kafkaConsumerStatsTimeout: Input.Optional[Int] = None,
    maxPartitionContexts: Input.Optional[Int] = None,
    site: Input.Optional[String] = None
  )(using Context): GetServiceIntegrationEndpointDatadogUserConfigArgs =
    new GetServiceIntegrationEndpointDatadogUserConfigArgs(
      datadogApiKey = datadogApiKey.asOutput(isSecret = true),
      datadogTags = datadogTags.asOptionOutput(isSecret = false),
      disableConsumerStats = disableConsumerStats.asOptionOutput(isSecret = false),
      kafkaConsumerCheckInstances = kafkaConsumerCheckInstances.asOptionOutput(isSecret = false),
      kafkaConsumerStatsTimeout = kafkaConsumerStatsTimeout.asOptionOutput(isSecret = false),
      maxPartitionContexts = maxPartitionContexts.asOptionOutput(isSecret = false),
      site = site.asOptionOutput(isSecret = false)
    )
