package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs private(
  accessKey: Output[String],
  namespace: Output[String],
  region: Output[String],
  secretKey: Output[String]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs:
  def apply(
    accessKey: Input[String],
    namespace: Input[String],
    region: Input[String],
    secretKey: Input[String]
  )(using Context): GetServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs =
    new GetServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs(
      accessKey = accessKey.asOutput(isSecret = false),
      namespace = namespace.asOutput(isSecret = false),
      region = region.asOutput(isSecret = false),
      secretKey = secretKey.asOutput(isSecret = false)
    )
