package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs private(
  logId: Output[String],
  projectId: Output[String],
  serviceAccountCredentials: Output[String]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs:
  def apply(
    logId: Input[String],
    projectId: Input[String],
    serviceAccountCredentials: Input[String]
  )(using Context): GetServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs =
    new GetServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs(
      logId = logId.asOutput(isSecret = false),
      projectId = projectId.asOutput(isSecret = false),
      serviceAccountCredentials = serviceAccountCredentials.asOutput(isSecret = false)
    )
