package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs private(
  authentication: Output[String],
  basicAuthPassword: Output[Option[String]],
  basicAuthUsername: Output[Option[String]],
  url: Output[String]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs:
  def apply(
    authentication: Input[String],
    basicAuthPassword: Input.Optional[String] = None,
    basicAuthUsername: Input.Optional[String] = None,
    url: Input[String]
  )(using Context): GetServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs =
    new GetServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs(
      authentication = authentication.asOutput(isSecret = false),
      basicAuthPassword = basicAuthPassword.asOptionOutput(isSecret = true),
      basicAuthUsername = basicAuthUsername.asOptionOutput(isSecret = false),
      url = url.asOutput(isSecret = false)
    )
