package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationEndpointRsyslogUserConfigArgs private(
  ca: Output[Option[String]],
  cert: Output[Option[String]],
  format: Output[String],
  key: Output[Option[String]],
  logline: Output[Option[String]],
  port: Output[Int],
  sd: Output[Option[String]],
  server: Output[String],
  tls: Output[Boolean]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationEndpointRsyslogUserConfigArgs:
  def apply(
    ca: Input.Optional[String] = None,
    cert: Input.Optional[String] = None,
    format: Input[String],
    key: Input.Optional[String] = None,
    logline: Input.Optional[String] = None,
    port: Input[Int],
    sd: Input.Optional[String] = None,
    server: Input[String],
    tls: Input[Boolean]
  )(using Context): GetServiceIntegrationEndpointRsyslogUserConfigArgs =
    new GetServiceIntegrationEndpointRsyslogUserConfigArgs(
      ca = ca.asOptionOutput(isSecret = false),
      cert = cert.asOptionOutput(isSecret = false),
      format = format.asOutput(isSecret = false),
      key = key.asOptionOutput(isSecret = false),
      logline = logline.asOptionOutput(isSecret = false),
      port = port.asOutput(isSecret = false),
      sd = sd.asOptionOutput(isSecret = false),
      server = server.asOutput(isSecret = false),
      tls = tls.asOutput(isSecret = false)
    )
