package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationKafkaLogsUserConfigArgs private(
  kafkaTopic: Output[String],
  selectedLogFields: Output[Option[scala.collection.immutable.List[String]]]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationKafkaLogsUserConfigArgs:
  def apply(
    kafkaTopic: Input[String],
    selectedLogFields: Input.Optional[List[Input[String]]] = None
  )(using Context): GetServiceIntegrationKafkaLogsUserConfigArgs =
    new GetServiceIntegrationKafkaLogsUserConfigArgs(
      kafkaTopic = kafkaTopic.asOutput(isSecret = false),
      selectedLogFields = selectedLogFields.asOptionOutput(isSecret = false)
    )
