package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormakerArgs private(
  consumerFetchMinBytes: Output[Option[Int]],
  producerBatchSize: Output[Option[Int]],
  producerBufferMemory: Output[Option[Int]],
  producerCompressionType: Output[Option[String]],
  producerLingerMs: Output[Option[Int]],
  producerMaxRequestSize: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormakerArgs:
  def apply(
    consumerFetchMinBytes: Input.Optional[Int] = None,
    producerBatchSize: Input.Optional[Int] = None,
    producerBufferMemory: Input.Optional[Int] = None,
    producerCompressionType: Input.Optional[String] = None,
    producerLingerMs: Input.Optional[Int] = None,
    producerMaxRequestSize: Input.Optional[Int] = None
  )(using Context): GetServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormakerArgs =
    new GetServiceIntegrationKafkaMirrormakerUserConfigKafkaMirrormakerArgs(
      consumerFetchMinBytes = consumerFetchMinBytes.asOptionOutput(isSecret = false),
      producerBatchSize = producerBatchSize.asOptionOutput(isSecret = false),
      producerBufferMemory = producerBufferMemory.asOptionOutput(isSecret = false),
      producerCompressionType = producerCompressionType.asOptionOutput(isSecret = false),
      producerLingerMs = producerLingerMs.asOptionOutput(isSecret = false),
      producerMaxRequestSize = producerMaxRequestSize.asOptionOutput(isSecret = false)
    )
