package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationLogsUserConfigArgs private(
  elasticsearchIndexDaysMax: Output[Option[Int]],
  elasticsearchIndexPrefix: Output[Option[String]],
  selectedLogFields: Output[Option[scala.collection.immutable.List[String]]]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationLogsUserConfigArgs:
  def apply(
    elasticsearchIndexDaysMax: Input.Optional[Int] = None,
    elasticsearchIndexPrefix: Input.Optional[String] = None,
    selectedLogFields: Input.Optional[List[Input[String]]] = None
  )(using Context): GetServiceIntegrationLogsUserConfigArgs =
    new GetServiceIntegrationLogsUserConfigArgs(
      elasticsearchIndexDaysMax = elasticsearchIndexDaysMax.asOptionOutput(isSecret = false),
      elasticsearchIndexPrefix = elasticsearchIndexPrefix.asOptionOutput(isSecret = false),
      selectedLogFields = selectedLogFields.asOptionOutput(isSecret = false)
    )
