package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetServiceIntegrationMetricsUserConfigArgs private(
  database: Output[Option[String]],
  retentionDays: Output[Option[Int]],
  roUsername: Output[Option[String]],
  sourceMysql: Output[Option[besom.api.aiven.inputs.GetServiceIntegrationMetricsUserConfigSourceMysqlArgs]],
  username: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetServiceIntegrationMetricsUserConfigArgs:
  def apply(
    database: Input.Optional[String] = None,
    retentionDays: Input.Optional[Int] = None,
    roUsername: Input.Optional[String] = None,
    sourceMysql: Input.Optional[besom.api.aiven.inputs.GetServiceIntegrationMetricsUserConfigSourceMysqlArgs] = None,
    username: Input.Optional[String] = None
  )(using Context): GetServiceIntegrationMetricsUserConfigArgs =
    new GetServiceIntegrationMetricsUserConfigArgs(
      database = database.asOptionOutput(isSecret = false),
      retentionDays = retentionDays.asOptionOutput(isSecret = false),
      roUsername = roUsername.asOptionOutput(isSecret = false),
      sourceMysql = sourceMysql.asOptionOutput(isSecret = false),
      username = username.asOptionOutput(isSecret = false)
    )
