package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GrafanaGrafanaUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  alertingEnabled: Output[Option[Boolean]],
  alertingErrorOrTimeout: Output[Option[String]],
  alertingMaxAnnotationsToKeep: Output[Option[Int]],
  alertingNodataOrNullvalues: Output[Option[String]],
  allowEmbedding: Output[Option[Boolean]],
  authAzuread: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthAzureadArgs]],
  authBasicEnabled: Output[Option[Boolean]],
  authGenericOauth: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGenericOauthArgs]],
  authGithub: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGithubArgs]],
  authGitlab: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGitlabArgs]],
  authGoogle: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGoogleArgs]],
  cookieSamesite: Output[Option[String]],
  customDomain: Output[Option[String]],
  dashboardPreviewsEnabled: Output[Option[Boolean]],
  dashboardsMinRefreshInterval: Output[Option[String]],
  dashboardsVersionsToKeep: Output[Option[Int]],
  dataproxySendUserHeader: Output[Option[Boolean]],
  dataproxyTimeout: Output[Option[Int]],
  dateFormats: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigDateFormatsArgs]],
  disableGravatar: Output[Option[Boolean]],
  editorsCanAdmin: Output[Option[Boolean]],
  externalImageStorage: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigExternalImageStorageArgs]],
  googleAnalyticsUaId: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GrafanaGrafanaUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  metricsEnabled: Output[Option[Boolean]],
  oauthAllowInsecureEmailLookup: Output[Option[Boolean]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigPrivatelinkAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigPublicAccessArgs]],
  recoveryBasebackupName: Output[Option[String]],
  serviceToForkFrom: Output[Option[String]],
  smtpServer: Output[Option[besom.api.aiven.inputs.GrafanaGrafanaUserConfigSmtpServerArgs]],
  staticIps: Output[Option[Boolean]],
  userAutoAssignOrg: Output[Option[Boolean]],
  userAutoAssignOrgRole: Output[Option[String]],
  viewersCanEdit: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GrafanaGrafanaUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    alertingEnabled: Input.Optional[Boolean] = None,
    alertingErrorOrTimeout: Input.Optional[String] = None,
    alertingMaxAnnotationsToKeep: Input.Optional[Int] = None,
    alertingNodataOrNullvalues: Input.Optional[String] = None,
    allowEmbedding: Input.Optional[Boolean] = None,
    authAzuread: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthAzureadArgs] = None,
    authBasicEnabled: Input.Optional[Boolean] = None,
    authGenericOauth: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGenericOauthArgs] = None,
    authGithub: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGithubArgs] = None,
    authGitlab: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGitlabArgs] = None,
    authGoogle: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigAuthGoogleArgs] = None,
    cookieSamesite: Input.Optional[String] = None,
    customDomain: Input.Optional[String] = None,
    dashboardPreviewsEnabled: Input.Optional[Boolean] = None,
    dashboardsMinRefreshInterval: Input.Optional[String] = None,
    dashboardsVersionsToKeep: Input.Optional[Int] = None,
    dataproxySendUserHeader: Input.Optional[Boolean] = None,
    dataproxyTimeout: Input.Optional[Int] = None,
    dateFormats: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigDateFormatsArgs] = None,
    disableGravatar: Input.Optional[Boolean] = None,
    editorsCanAdmin: Input.Optional[Boolean] = None,
    externalImageStorage: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigExternalImageStorageArgs] = None,
    googleAnalyticsUaId: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GrafanaGrafanaUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    metricsEnabled: Input.Optional[Boolean] = None,
    oauthAllowInsecureEmailLookup: Input.Optional[Boolean] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigPrivatelinkAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigPublicAccessArgs] = None,
    recoveryBasebackupName: Input.Optional[String] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    smtpServer: Input.Optional[besom.api.aiven.inputs.GrafanaGrafanaUserConfigSmtpServerArgs] = None,
    staticIps: Input.Optional[Boolean] = None,
    userAutoAssignOrg: Input.Optional[Boolean] = None,
    userAutoAssignOrgRole: Input.Optional[String] = None,
    viewersCanEdit: Input.Optional[Boolean] = None
  )(using Context): GrafanaGrafanaUserConfigArgs =
    new GrafanaGrafanaUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      alertingEnabled = alertingEnabled.asOptionOutput(isSecret = false),
      alertingErrorOrTimeout = alertingErrorOrTimeout.asOptionOutput(isSecret = false),
      alertingMaxAnnotationsToKeep = alertingMaxAnnotationsToKeep.asOptionOutput(isSecret = false),
      alertingNodataOrNullvalues = alertingNodataOrNullvalues.asOptionOutput(isSecret = false),
      allowEmbedding = allowEmbedding.asOptionOutput(isSecret = false),
      authAzuread = authAzuread.asOptionOutput(isSecret = false),
      authBasicEnabled = authBasicEnabled.asOptionOutput(isSecret = false),
      authGenericOauth = authGenericOauth.asOptionOutput(isSecret = false),
      authGithub = authGithub.asOptionOutput(isSecret = false),
      authGitlab = authGitlab.asOptionOutput(isSecret = false),
      authGoogle = authGoogle.asOptionOutput(isSecret = false),
      cookieSamesite = cookieSamesite.asOptionOutput(isSecret = false),
      customDomain = customDomain.asOptionOutput(isSecret = false),
      dashboardPreviewsEnabled = dashboardPreviewsEnabled.asOptionOutput(isSecret = false),
      dashboardsMinRefreshInterval = dashboardsMinRefreshInterval.asOptionOutput(isSecret = false),
      dashboardsVersionsToKeep = dashboardsVersionsToKeep.asOptionOutput(isSecret = false),
      dataproxySendUserHeader = dataproxySendUserHeader.asOptionOutput(isSecret = false),
      dataproxyTimeout = dataproxyTimeout.asOptionOutput(isSecret = false),
      dateFormats = dateFormats.asOptionOutput(isSecret = false),
      disableGravatar = disableGravatar.asOptionOutput(isSecret = false),
      editorsCanAdmin = editorsCanAdmin.asOptionOutput(isSecret = false),
      externalImageStorage = externalImageStorage.asOptionOutput(isSecret = false),
      googleAnalyticsUaId = googleAnalyticsUaId.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      metricsEnabled = metricsEnabled.asOptionOutput(isSecret = false),
      oauthAllowInsecureEmailLookup = oauthAllowInsecureEmailLookup.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      recoveryBasebackupName = recoveryBasebackupName.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      smtpServer = smtpServer.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      userAutoAssignOrg = userAutoAssignOrg.asOptionOutput(isSecret = false),
      userAutoAssignOrgRole = userAutoAssignOrgRole.asOptionOutput(isSecret = false),
      viewersCanEdit = viewersCanEdit.asOptionOutput(isSecret = false)
    )
