package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GrafanaGrafanaUserConfigAuthGenericOauthArgs private(
  allowSignUp: Output[Option[Boolean]],
  allowedDomains: Output[Option[scala.collection.immutable.List[String]]],
  allowedOrganizations: Output[Option[scala.collection.immutable.List[String]]],
  apiUrl: Output[String],
  authUrl: Output[String],
  autoLogin: Output[Option[Boolean]],
  clientId: Output[String],
  clientSecret: Output[String],
  name: Output[Option[String]],
  scopes: Output[Option[scala.collection.immutable.List[String]]],
  tokenUrl: Output[String]
) derives Encoder, ArgsEncoder

object GrafanaGrafanaUserConfigAuthGenericOauthArgs:
  def apply(
    allowSignUp: Input.Optional[Boolean] = None,
    allowedDomains: Input.Optional[List[Input[String]]] = None,
    allowedOrganizations: Input.Optional[List[Input[String]]] = None,
    apiUrl: Input[String],
    authUrl: Input[String],
    autoLogin: Input.Optional[Boolean] = None,
    clientId: Input[String],
    clientSecret: Input[String],
    name: Input.Optional[String] = None,
    scopes: Input.Optional[List[Input[String]]] = None,
    tokenUrl: Input[String]
  )(using Context): GrafanaGrafanaUserConfigAuthGenericOauthArgs =
    new GrafanaGrafanaUserConfigAuthGenericOauthArgs(
      allowSignUp = allowSignUp.asOptionOutput(isSecret = false),
      allowedDomains = allowedDomains.asOptionOutput(isSecret = false),
      allowedOrganizations = allowedOrganizations.asOptionOutput(isSecret = false),
      apiUrl = apiUrl.asOutput(isSecret = false),
      authUrl = authUrl.asOutput(isSecret = false),
      autoLogin = autoLogin.asOptionOutput(isSecret = false),
      clientId = clientId.asOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      scopes = scopes.asOptionOutput(isSecret = false),
      tokenUrl = tokenUrl.asOutput(isSecret = false)
    )
