package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GrafanaGrafanaUserConfigExternalImageStorageArgs private(
  accessKey: Output[String],
  bucketUrl: Output[String],
  provider: Output[String],
  secretKey: Output[String]
) derives Encoder, ArgsEncoder

object GrafanaGrafanaUserConfigExternalImageStorageArgs:
  def apply(
    accessKey: Input[String],
    bucketUrl: Input[String],
    provider: Input[String],
    secretKey: Input[String]
  )(using Context): GrafanaGrafanaUserConfigExternalImageStorageArgs =
    new GrafanaGrafanaUserConfigExternalImageStorageArgs(
      accessKey = accessKey.asOutput(isSecret = false),
      bucketUrl = bucketUrl.asOutput(isSecret = false),
      provider = provider.asOutput(isSecret = false),
      secretKey = secretKey.asOutput(isSecret = false)
    )
