package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GrafanaGrafanaUserConfigIpFilterObjectArgs private(
  description: Output[Option[String]],
  network: Output[String]
) derives Encoder, ArgsEncoder

object GrafanaGrafanaUserConfigIpFilterObjectArgs:
  def apply(
    description: Input.Optional[String] = None,
    network: Input[String]
  )(using Context): GrafanaGrafanaUserConfigIpFilterObjectArgs =
    new GrafanaGrafanaUserConfigIpFilterObjectArgs(
      description = description.asOptionOutput(isSecret = false),
      network = network.asOutput(isSecret = false)
    )
