package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GrafanaGrafanaUserConfigPrivateAccessArgs private(
  grafana: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GrafanaGrafanaUserConfigPrivateAccessArgs:
  def apply(
    grafana: Input.Optional[Boolean] = None
  )(using Context): GrafanaGrafanaUserConfigPrivateAccessArgs =
    new GrafanaGrafanaUserConfigPrivateAccessArgs(
      grafana = grafana.asOptionOutput(isSecret = false)
    )
