package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GrafanaGrafanaUserConfigSmtpServerArgs private(
  fromAddress: Output[String],
  fromName: Output[Option[String]],
  host: Output[String],
  password: Output[Option[String]],
  port: Output[Int],
  skipVerify: Output[Option[Boolean]],
  starttlsPolicy: Output[Option[String]],
  username: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GrafanaGrafanaUserConfigSmtpServerArgs:
  def apply(
    fromAddress: Input[String],
    fromName: Input.Optional[String] = None,
    host: Input[String],
    password: Input.Optional[String] = None,
    port: Input[Int],
    skipVerify: Input.Optional[Boolean] = None,
    starttlsPolicy: Input.Optional[String] = None,
    username: Input.Optional[String] = None
  )(using Context): GrafanaGrafanaUserConfigSmtpServerArgs =
    new GrafanaGrafanaUserConfigSmtpServerArgs(
      fromAddress = fromAddress.asOutput(isSecret = false),
      fromName = fromName.asOptionOutput(isSecret = false),
      host = host.asOutput(isSecret = false),
      password = password.asOptionOutput(isSecret = true),
      port = port.asOutput(isSecret = false),
      skipVerify = skipVerify.asOptionOutput(isSecret = false),
      starttlsPolicy = starttlsPolicy.asOptionOutput(isSecret = false),
      username = username.asOptionOutput(isSecret = false)
    )
