package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class InfluxDbInfluxdbArgs private(
  databaseName: Output[Option[String]]
) derives Encoder, ArgsEncoder

object InfluxDbInfluxdbArgs:
  def apply(
    databaseName: Input.Optional[String] = None
  )(using Context): InfluxDbInfluxdbArgs =
    new InfluxDbInfluxdbArgs(
      databaseName = databaseName.asOptionOutput(isSecret = false)
    )
