package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class InfluxDbInfluxdbUserConfigInfluxdbArgs private(
  logQueriesAfter: Output[Option[Int]],
  maxConnectionLimit: Output[Option[Int]],
  maxRowLimit: Output[Option[Int]],
  maxSelectBuckets: Output[Option[Int]],
  maxSelectPoint: Output[Option[Int]],
  queryLogEnabled: Output[Option[Boolean]],
  queryTimeout: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object InfluxDbInfluxdbUserConfigInfluxdbArgs:
  def apply(
    logQueriesAfter: Input.Optional[Int] = None,
    maxConnectionLimit: Input.Optional[Int] = None,
    maxRowLimit: Input.Optional[Int] = None,
    maxSelectBuckets: Input.Optional[Int] = None,
    maxSelectPoint: Input.Optional[Int] = None,
    queryLogEnabled: Input.Optional[Boolean] = None,
    queryTimeout: Input.Optional[Int] = None
  )(using Context): InfluxDbInfluxdbUserConfigInfluxdbArgs =
    new InfluxDbInfluxdbUserConfigInfluxdbArgs(
      logQueriesAfter = logQueriesAfter.asOptionOutput(isSecret = false),
      maxConnectionLimit = maxConnectionLimit.asOptionOutput(isSecret = false),
      maxRowLimit = maxRowLimit.asOptionOutput(isSecret = false),
      maxSelectBuckets = maxSelectBuckets.asOptionOutput(isSecret = false),
      maxSelectPoint = maxSelectPoint.asOptionOutput(isSecret = false),
      queryLogEnabled = queryLogEnabled.asOptionOutput(isSecret = false),
      queryTimeout = queryTimeout.asOptionOutput(isSecret = false)
    )
