package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class InfluxDbTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object InfluxDbTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): InfluxDbTagArgs =
    new InfluxDbTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
