package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaConnectKafkaConnectUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  kafkaConnect: Output[Option[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigKafkaConnectArgs]],
  privateAccess: Output[Option[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigPrivatelinkAccessArgs]],
  publicAccess: Output[Option[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigPublicAccessArgs]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object KafkaConnectKafkaConnectUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    kafkaConnect: Input.Optional[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigKafkaConnectArgs] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigPrivatelinkAccessArgs] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.KafkaConnectKafkaConnectUserConfigPublicAccessArgs] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): KafkaConnectKafkaConnectUserConfigArgs =
    new KafkaConnectKafkaConnectUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
