package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaConnectKafkaConnectUserConfigPrivateAccessArgs private(
  kafkaConnect: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object KafkaConnectKafkaConnectUserConfigPrivateAccessArgs:
  def apply(
    kafkaConnect: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): KafkaConnectKafkaConnectUserConfigPrivateAccessArgs =
    new KafkaConnectKafkaConnectUserConfigPrivateAccessArgs(
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
