package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaConnectorTaskArgs private(
  connector: Output[Option[String]],
  task: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object KafkaConnectorTaskArgs:
  def apply(
    connector: Input.Optional[String] = None,
    task: Input.Optional[Int] = None
  )(using Context): KafkaConnectorTaskArgs =
    new KafkaConnectorTaskArgs(
      connector = connector.asOptionOutput(isSecret = false),
      task = task.asOptionOutput(isSecret = false)
    )
