package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaArgs private(
  accessCert: Output[Option[String]],
  accessKey: Output[Option[String]],
  connectUri: Output[Option[String]],
  restUri: Output[Option[String]],
  schemaRegistryUri: Output[Option[String]]
) derives Encoder, ArgsEncoder

object KafkaKafkaArgs:
  def apply(
    accessCert: Input.Optional[String] = None,
    accessKey: Input.Optional[String] = None,
    connectUri: Input.Optional[String] = None,
    restUri: Input.Optional[String] = None,
    schemaRegistryUri: Input.Optional[String] = None
  )(using Context): KafkaKafkaArgs =
    new KafkaKafkaArgs(
      accessCert = accessCert.asOptionOutput(isSecret = true),
      accessKey = accessKey.asOptionOutput(isSecret = true),
      connectUri = connectUri.asOptionOutput(isSecret = true),
      restUri = restUri.asOptionOutput(isSecret = true),
      schemaRegistryUri = schemaRegistryUri.asOptionOutput(isSecret = true)
    )
