package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  customDomain: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.KafkaKafkaUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  kafka: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaArgs]],
  kafkaAuthenticationMethods: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaAuthenticationMethodsArgs]],
  kafkaConnect: Output[Option[Boolean]],
  kafkaConnectConfig: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaConnectConfigArgs]],
  kafkaRest: Output[Option[Boolean]],
  kafkaRestAuthorization: Output[Option[Boolean]],
  kafkaRestConfig: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaRestConfigArgs]],
  kafkaVersion: Output[Option[String]],
  privateAccess: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigPrivatelinkAccessArgs]],
  publicAccess: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigPublicAccessArgs]],
  schemaRegistry: Output[Option[Boolean]],
  schemaRegistryConfig: Output[Option[besom.api.aiven.inputs.KafkaKafkaUserConfigSchemaRegistryConfigArgs]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    customDomain: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.KafkaKafkaUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    kafka: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaArgs] = None,
    kafkaAuthenticationMethods: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaAuthenticationMethodsArgs] = None,
    kafkaConnect: Input.Optional[Boolean] = None,
    kafkaConnectConfig: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaConnectConfigArgs] = None,
    kafkaRest: Input.Optional[Boolean] = None,
    kafkaRestAuthorization: Input.Optional[Boolean] = None,
    kafkaRestConfig: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigKafkaRestConfigArgs] = None,
    kafkaVersion: Input.Optional[String] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigPrivatelinkAccessArgs] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigPublicAccessArgs] = None,
    schemaRegistry: Input.Optional[Boolean] = None,
    schemaRegistryConfig: Input.Optional[besom.api.aiven.inputs.KafkaKafkaUserConfigSchemaRegistryConfigArgs] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): KafkaKafkaUserConfigArgs =
    new KafkaKafkaUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      customDomain = customDomain.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      kafka = kafka.asOptionOutput(isSecret = false),
      kafkaAuthenticationMethods = kafkaAuthenticationMethods.asOptionOutput(isSecret = false),
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      kafkaConnectConfig = kafkaConnectConfig.asOptionOutput(isSecret = false),
      kafkaRest = kafkaRest.asOptionOutput(isSecret = false),
      kafkaRestAuthorization = kafkaRestAuthorization.asOptionOutput(isSecret = false),
      kafkaRestConfig = kafkaRestConfig.asOptionOutput(isSecret = false),
      kafkaVersion = kafkaVersion.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      schemaRegistry = schemaRegistry.asOptionOutput(isSecret = false),
      schemaRegistryConfig = schemaRegistryConfig.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
