package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigIpFilterObjectArgs private(
  description: Output[Option[String]],
  network: Output[String]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigIpFilterObjectArgs:
  def apply(
    description: Input.Optional[String] = None,
    network: Input[String]
  )(using Context): KafkaKafkaUserConfigIpFilterObjectArgs =
    new KafkaKafkaUserConfigIpFilterObjectArgs(
      description = description.asOptionOutput(isSecret = false),
      network = network.asOutput(isSecret = false)
    )
