package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigKafkaConnectConfigArgs private(
  connectorClientConfigOverridePolicy: Output[Option[String]],
  consumerAutoOffsetReset: Output[Option[String]],
  consumerFetchMaxBytes: Output[Option[Int]],
  consumerIsolationLevel: Output[Option[String]],
  consumerMaxPartitionFetchBytes: Output[Option[Int]],
  consumerMaxPollIntervalMs: Output[Option[Int]],
  consumerMaxPollRecords: Output[Option[Int]],
  offsetFlushIntervalMs: Output[Option[Int]],
  offsetFlushTimeoutMs: Output[Option[Int]],
  producerBatchSize: Output[Option[Int]],
  producerBufferMemory: Output[Option[Int]],
  producerCompressionType: Output[Option[String]],
  producerLingerMs: Output[Option[Int]],
  producerMaxRequestSize: Output[Option[Int]],
  scheduledRebalanceMaxDelayMs: Output[Option[Int]],
  sessionTimeoutMs: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigKafkaConnectConfigArgs:
  def apply(
    connectorClientConfigOverridePolicy: Input.Optional[String] = None,
    consumerAutoOffsetReset: Input.Optional[String] = None,
    consumerFetchMaxBytes: Input.Optional[Int] = None,
    consumerIsolationLevel: Input.Optional[String] = None,
    consumerMaxPartitionFetchBytes: Input.Optional[Int] = None,
    consumerMaxPollIntervalMs: Input.Optional[Int] = None,
    consumerMaxPollRecords: Input.Optional[Int] = None,
    offsetFlushIntervalMs: Input.Optional[Int] = None,
    offsetFlushTimeoutMs: Input.Optional[Int] = None,
    producerBatchSize: Input.Optional[Int] = None,
    producerBufferMemory: Input.Optional[Int] = None,
    producerCompressionType: Input.Optional[String] = None,
    producerLingerMs: Input.Optional[Int] = None,
    producerMaxRequestSize: Input.Optional[Int] = None,
    scheduledRebalanceMaxDelayMs: Input.Optional[Int] = None,
    sessionTimeoutMs: Input.Optional[Int] = None
  )(using Context): KafkaKafkaUserConfigKafkaConnectConfigArgs =
    new KafkaKafkaUserConfigKafkaConnectConfigArgs(
      connectorClientConfigOverridePolicy = connectorClientConfigOverridePolicy.asOptionOutput(isSecret = false),
      consumerAutoOffsetReset = consumerAutoOffsetReset.asOptionOutput(isSecret = false),
      consumerFetchMaxBytes = consumerFetchMaxBytes.asOptionOutput(isSecret = false),
      consumerIsolationLevel = consumerIsolationLevel.asOptionOutput(isSecret = false),
      consumerMaxPartitionFetchBytes = consumerMaxPartitionFetchBytes.asOptionOutput(isSecret = false),
      consumerMaxPollIntervalMs = consumerMaxPollIntervalMs.asOptionOutput(isSecret = false),
      consumerMaxPollRecords = consumerMaxPollRecords.asOptionOutput(isSecret = false),
      offsetFlushIntervalMs = offsetFlushIntervalMs.asOptionOutput(isSecret = false),
      offsetFlushTimeoutMs = offsetFlushTimeoutMs.asOptionOutput(isSecret = false),
      producerBatchSize = producerBatchSize.asOptionOutput(isSecret = false),
      producerBufferMemory = producerBufferMemory.asOptionOutput(isSecret = false),
      producerCompressionType = producerCompressionType.asOptionOutput(isSecret = false),
      producerLingerMs = producerLingerMs.asOptionOutput(isSecret = false),
      producerMaxRequestSize = producerMaxRequestSize.asOptionOutput(isSecret = false),
      scheduledRebalanceMaxDelayMs = scheduledRebalanceMaxDelayMs.asOptionOutput(isSecret = false),
      sessionTimeoutMs = sessionTimeoutMs.asOptionOutput(isSecret = false)
    )
