package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigKafkaRestConfigArgs private(
  consumerEnableAutoCommit: Output[Option[Boolean]],
  consumerRequestMaxBytes: Output[Option[Int]],
  consumerRequestTimeoutMs: Output[Option[Int]],
  producerAcks: Output[Option[String]],
  producerCompressionType: Output[Option[String]],
  producerLingerMs: Output[Option[Int]],
  producerMaxRequestSize: Output[Option[Int]],
  simpleconsumerPoolSizeMax: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigKafkaRestConfigArgs:
  def apply(
    consumerEnableAutoCommit: Input.Optional[Boolean] = None,
    consumerRequestMaxBytes: Input.Optional[Int] = None,
    consumerRequestTimeoutMs: Input.Optional[Int] = None,
    producerAcks: Input.Optional[String] = None,
    producerCompressionType: Input.Optional[String] = None,
    producerLingerMs: Input.Optional[Int] = None,
    producerMaxRequestSize: Input.Optional[Int] = None,
    simpleconsumerPoolSizeMax: Input.Optional[Int] = None
  )(using Context): KafkaKafkaUserConfigKafkaRestConfigArgs =
    new KafkaKafkaUserConfigKafkaRestConfigArgs(
      consumerEnableAutoCommit = consumerEnableAutoCommit.asOptionOutput(isSecret = false),
      consumerRequestMaxBytes = consumerRequestMaxBytes.asOptionOutput(isSecret = false),
      consumerRequestTimeoutMs = consumerRequestTimeoutMs.asOptionOutput(isSecret = false),
      producerAcks = producerAcks.asOptionOutput(isSecret = false),
      producerCompressionType = producerCompressionType.asOptionOutput(isSecret = false),
      producerLingerMs = producerLingerMs.asOptionOutput(isSecret = false),
      producerMaxRequestSize = producerMaxRequestSize.asOptionOutput(isSecret = false),
      simpleconsumerPoolSizeMax = simpleconsumerPoolSizeMax.asOptionOutput(isSecret = false)
    )
