package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigPrivateAccessArgs private(
  kafka: Output[Option[Boolean]],
  kafkaConnect: Output[Option[Boolean]],
  kafkaRest: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]],
  schemaRegistry: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigPrivateAccessArgs:
  def apply(
    kafka: Input.Optional[Boolean] = None,
    kafkaConnect: Input.Optional[Boolean] = None,
    kafkaRest: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None,
    schemaRegistry: Input.Optional[Boolean] = None
  )(using Context): KafkaKafkaUserConfigPrivateAccessArgs =
    new KafkaKafkaUserConfigPrivateAccessArgs(
      kafka = kafka.asOptionOutput(isSecret = false),
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      kafkaRest = kafkaRest.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false),
      schemaRegistry = schemaRegistry.asOptionOutput(isSecret = false)
    )
