package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigPublicAccessArgs private(
  kafka: Output[Option[Boolean]],
  kafkaConnect: Output[Option[Boolean]],
  kafkaRest: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]],
  schemaRegistry: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigPublicAccessArgs:
  def apply(
    kafka: Input.Optional[Boolean] = None,
    kafkaConnect: Input.Optional[Boolean] = None,
    kafkaRest: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None,
    schemaRegistry: Input.Optional[Boolean] = None
  )(using Context): KafkaKafkaUserConfigPublicAccessArgs =
    new KafkaKafkaUserConfigPublicAccessArgs(
      kafka = kafka.asOptionOutput(isSecret = false),
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      kafkaRest = kafkaRest.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false),
      schemaRegistry = schemaRegistry.asOptionOutput(isSecret = false)
    )
