package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaKafkaUserConfigSchemaRegistryConfigArgs private(
  leaderEligibility: Output[Option[Boolean]],
  topicName: Output[Option[String]]
) derives Encoder, ArgsEncoder

object KafkaKafkaUserConfigSchemaRegistryConfigArgs:
  def apply(
    leaderEligibility: Input.Optional[Boolean] = None,
    topicName: Input.Optional[String] = None
  )(using Context): KafkaKafkaUserConfigSchemaRegistryConfigArgs =
    new KafkaKafkaUserConfigSchemaRegistryConfigArgs(
      leaderEligibility = leaderEligibility.asOptionOutput(isSecret = false),
      topicName = topicName.asOptionOutput(isSecret = false)
    )
