package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaMirrorMakerServiceIntegrationArgs private(
  integrationType: Output[String],
  sourceServiceName: Output[String]
) derives Encoder, ArgsEncoder

object KafkaMirrorMakerServiceIntegrationArgs:
  def apply(
    integrationType: Input[String],
    sourceServiceName: Input[String]
  )(using Context): KafkaMirrorMakerServiceIntegrationArgs =
    new KafkaMirrorMakerServiceIntegrationArgs(
      integrationType = integrationType.asOutput(isSecret = false),
      sourceServiceName = sourceServiceName.asOutput(isSecret = false)
    )
