package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaTopicConfigArgs private(
  cleanupPolicy: Output[Option[String]],
  compressionType: Output[Option[String]],
  deleteRetentionMs: Output[Option[String]],
  fileDeleteDelayMs: Output[Option[String]],
  flushMessages: Output[Option[String]],
  flushMs: Output[Option[String]],
  indexIntervalBytes: Output[Option[String]],
  maxCompactionLagMs: Output[Option[String]],
  maxMessageBytes: Output[Option[String]],
  messageDownconversionEnable: Output[Option[Boolean]],
  messageFormatVersion: Output[Option[String]],
  messageTimestampDifferenceMaxMs: Output[Option[String]],
  messageTimestampType: Output[Option[String]],
  minCleanableDirtyRatio: Output[Option[Double]],
  minCompactionLagMs: Output[Option[String]],
  minInsyncReplicas: Output[Option[String]],
  preallocate: Output[Option[Boolean]],
  retentionBytes: Output[Option[String]],
  retentionMs: Output[Option[String]],
  segmentBytes: Output[Option[String]],
  segmentIndexBytes: Output[Option[String]],
  segmentJitterMs: Output[Option[String]],
  segmentMs: Output[Option[String]],
  uncleanLeaderElectionEnable: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object KafkaTopicConfigArgs:
  def apply(
    cleanupPolicy: Input.Optional[String] = None,
    compressionType: Input.Optional[String] = None,
    deleteRetentionMs: Input.Optional[String] = None,
    fileDeleteDelayMs: Input.Optional[String] = None,
    flushMessages: Input.Optional[String] = None,
    flushMs: Input.Optional[String] = None,
    indexIntervalBytes: Input.Optional[String] = None,
    maxCompactionLagMs: Input.Optional[String] = None,
    maxMessageBytes: Input.Optional[String] = None,
    messageDownconversionEnable: Input.Optional[Boolean] = None,
    messageFormatVersion: Input.Optional[String] = None,
    messageTimestampDifferenceMaxMs: Input.Optional[String] = None,
    messageTimestampType: Input.Optional[String] = None,
    minCleanableDirtyRatio: Input.Optional[Double] = None,
    minCompactionLagMs: Input.Optional[String] = None,
    minInsyncReplicas: Input.Optional[String] = None,
    preallocate: Input.Optional[Boolean] = None,
    retentionBytes: Input.Optional[String] = None,
    retentionMs: Input.Optional[String] = None,
    segmentBytes: Input.Optional[String] = None,
    segmentIndexBytes: Input.Optional[String] = None,
    segmentJitterMs: Input.Optional[String] = None,
    segmentMs: Input.Optional[String] = None,
    uncleanLeaderElectionEnable: Input.Optional[Boolean] = None
  )(using Context): KafkaTopicConfigArgs =
    new KafkaTopicConfigArgs(
      cleanupPolicy = cleanupPolicy.asOptionOutput(isSecret = false),
      compressionType = compressionType.asOptionOutput(isSecret = false),
      deleteRetentionMs = deleteRetentionMs.asOptionOutput(isSecret = false),
      fileDeleteDelayMs = fileDeleteDelayMs.asOptionOutput(isSecret = false),
      flushMessages = flushMessages.asOptionOutput(isSecret = false),
      flushMs = flushMs.asOptionOutput(isSecret = false),
      indexIntervalBytes = indexIntervalBytes.asOptionOutput(isSecret = false),
      maxCompactionLagMs = maxCompactionLagMs.asOptionOutput(isSecret = false),
      maxMessageBytes = maxMessageBytes.asOptionOutput(isSecret = false),
      messageDownconversionEnable = messageDownconversionEnable.asOptionOutput(isSecret = false),
      messageFormatVersion = messageFormatVersion.asOptionOutput(isSecret = false),
      messageTimestampDifferenceMaxMs = messageTimestampDifferenceMaxMs.asOptionOutput(isSecret = false),
      messageTimestampType = messageTimestampType.asOptionOutput(isSecret = false),
      minCleanableDirtyRatio = minCleanableDirtyRatio.asOptionOutput(isSecret = false),
      minCompactionLagMs = minCompactionLagMs.asOptionOutput(isSecret = false),
      minInsyncReplicas = minInsyncReplicas.asOptionOutput(isSecret = false),
      preallocate = preallocate.asOptionOutput(isSecret = false),
      retentionBytes = retentionBytes.asOptionOutput(isSecret = false),
      retentionMs = retentionMs.asOptionOutput(isSecret = false),
      segmentBytes = segmentBytes.asOptionOutput(isSecret = false),
      segmentIndexBytes = segmentIndexBytes.asOptionOutput(isSecret = false),
      segmentJitterMs = segmentJitterMs.asOptionOutput(isSecret = false),
      segmentMs = segmentMs.asOptionOutput(isSecret = false),
      uncleanLeaderElectionEnable = uncleanLeaderElectionEnable.asOptionOutput(isSecret = false)
    )
