package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class KafkaTopicTagArgs private(
  key: Output[String],
  value: Output[Option[String]]
) derives Encoder, ArgsEncoder

object KafkaTopicTagArgs:
  def apply(
    key: Input[String],
    value: Input.Optional[String] = None
  )(using Context): KafkaTopicTagArgs =
    new KafkaTopicTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOptionOutput(isSecret = false)
    )
