package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class M3DbM3dbUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  customDomain: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.M3DbM3dbUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  limits: Output[Option[besom.api.aiven.inputs.M3DbM3dbUserConfigLimitsArgs]],
  m3: Output[Option[besom.api.aiven.inputs.M3DbM3dbUserConfigM3Args]],
  m3Version: Output[Option[String]],
  m3coordinatorEnableGraphiteCarbonIngest: Output[Option[Boolean]],
  m3dbVersion: Output[Option[String]],
  namespaces: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.M3DbM3dbUserConfigNamespaceArgs]]],
  privateAccess: Output[Option[besom.api.aiven.inputs.M3DbM3dbUserConfigPrivateAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.M3DbM3dbUserConfigPublicAccessArgs]],
  rules: Output[Option[besom.api.aiven.inputs.M3DbM3dbUserConfigRulesArgs]],
  serviceToForkFrom: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object M3DbM3dbUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    customDomain: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.M3DbM3dbUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    limits: Input.Optional[besom.api.aiven.inputs.M3DbM3dbUserConfigLimitsArgs] = None,
    m3: Input.Optional[besom.api.aiven.inputs.M3DbM3dbUserConfigM3Args] = None,
    m3Version: Input.Optional[String] = None,
    m3coordinatorEnableGraphiteCarbonIngest: Input.Optional[Boolean] = None,
    m3dbVersion: Input.Optional[String] = None,
    namespaces: Input.Optional[List[Input[besom.api.aiven.inputs.M3DbM3dbUserConfigNamespaceArgs]]] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.M3DbM3dbUserConfigPrivateAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.M3DbM3dbUserConfigPublicAccessArgs] = None,
    rules: Input.Optional[besom.api.aiven.inputs.M3DbM3dbUserConfigRulesArgs] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): M3DbM3dbUserConfigArgs =
    new M3DbM3dbUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      customDomain = customDomain.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      limits = limits.asOptionOutput(isSecret = false),
      m3 = m3.asOptionOutput(isSecret = false),
      m3Version = m3Version.asOptionOutput(isSecret = false),
      m3coordinatorEnableGraphiteCarbonIngest = m3coordinatorEnableGraphiteCarbonIngest.asOptionOutput(isSecret = false),
      m3dbVersion = m3dbVersion.asOptionOutput(isSecret = false),
      namespaces = namespaces.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      rules = rules.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
