package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class M3DbM3dbUserConfigNamespaceOptionsArgs private(
  retentionOptions: Output[Option[besom.api.aiven.inputs.M3DbM3dbUserConfigNamespaceOptionsRetentionOptionsArgs]],
  snapshotEnabled: Output[Option[Boolean]],
  writesToCommitlog: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object M3DbM3dbUserConfigNamespaceOptionsArgs:
  def apply(
    retentionOptions: Input.Optional[besom.api.aiven.inputs.M3DbM3dbUserConfigNamespaceOptionsRetentionOptionsArgs] = None,
    snapshotEnabled: Input.Optional[Boolean] = None,
    writesToCommitlog: Input.Optional[Boolean] = None
  )(using Context): M3DbM3dbUserConfigNamespaceOptionsArgs =
    new M3DbM3dbUserConfigNamespaceOptionsArgs(
      retentionOptions = retentionOptions.asOptionOutput(isSecret = false),
      snapshotEnabled = snapshotEnabled.asOptionOutput(isSecret = false),
      writesToCommitlog = writesToCommitlog.asOptionOutput(isSecret = false)
    )
