package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class M3DbM3dbUserConfigNamespaceOptionsRetentionOptionsArgs private(
  blockDataExpiryDuration: Output[Option[String]],
  blocksizeDuration: Output[Option[String]],
  bufferFutureDuration: Output[Option[String]],
  bufferPastDuration: Output[Option[String]],
  retentionPeriodDuration: Output[Option[String]]
) derives Encoder, ArgsEncoder

object M3DbM3dbUserConfigNamespaceOptionsRetentionOptionsArgs:
  def apply(
    blockDataExpiryDuration: Input.Optional[String] = None,
    blocksizeDuration: Input.Optional[String] = None,
    bufferFutureDuration: Input.Optional[String] = None,
    bufferPastDuration: Input.Optional[String] = None,
    retentionPeriodDuration: Input.Optional[String] = None
  )(using Context): M3DbM3dbUserConfigNamespaceOptionsRetentionOptionsArgs =
    new M3DbM3dbUserConfigNamespaceOptionsRetentionOptionsArgs(
      blockDataExpiryDuration = blockDataExpiryDuration.asOptionOutput(isSecret = false),
      blocksizeDuration = blocksizeDuration.asOptionOutput(isSecret = false),
      bufferFutureDuration = bufferFutureDuration.asOptionOutput(isSecret = false),
      bufferPastDuration = bufferPastDuration.asOptionOutput(isSecret = false),
      retentionPeriodDuration = retentionPeriodDuration.asOptionOutput(isSecret = false)
    )
