package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class M3DbTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object M3DbTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): M3DbTagArgs =
    new M3DbTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
