package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchArgs private(
  opensearchDashboardsUri: Output[Option[String]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchArgs:
  def apply(
    opensearchDashboardsUri: Input.Optional[String] = None
  )(using Context): OpenSearchOpensearchArgs =
    new OpenSearchOpensearchArgs(
      opensearchDashboardsUri = opensearchDashboardsUri.asOptionOutput(isSecret = true)
    )
