package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchUserConfigIndexTemplateArgs private(
  mappingNestedObjectsLimit: Output[Option[Int]],
  numberOfReplicas: Output[Option[Int]],
  numberOfShards: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchUserConfigIndexTemplateArgs:
  def apply(
    mappingNestedObjectsLimit: Input.Optional[Int] = None,
    numberOfReplicas: Input.Optional[Int] = None,
    numberOfShards: Input.Optional[Int] = None
  )(using Context): OpenSearchOpensearchUserConfigIndexTemplateArgs =
    new OpenSearchOpensearchUserConfigIndexTemplateArgs(
      mappingNestedObjectsLimit = mappingNestedObjectsLimit.asOptionOutput(isSecret = false),
      numberOfReplicas = numberOfReplicas.asOptionOutput(isSecret = false),
      numberOfShards = numberOfShards.asOptionOutput(isSecret = false)
    )
