package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchUserConfigOpenidArgs private(
  clientId: Output[String],
  clientSecret: Output[String],
  connectUrl: Output[String],
  enabled: Output[Option[Boolean]],
  header: Output[Option[String]],
  jwtHeader: Output[Option[String]],
  jwtUrlParameter: Output[Option[String]],
  refreshRateLimitCount: Output[Option[Int]],
  refreshRateLimitTimeWindowMs: Output[Option[Int]],
  rolesKey: Output[Option[String]],
  scope: Output[Option[String]],
  subjectKey: Output[Option[String]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchUserConfigOpenidArgs:
  def apply(
    clientId: Input[String],
    clientSecret: Input[String],
    connectUrl: Input[String],
    enabled: Input.Optional[Boolean] = None,
    header: Input.Optional[String] = None,
    jwtHeader: Input.Optional[String] = None,
    jwtUrlParameter: Input.Optional[String] = None,
    refreshRateLimitCount: Input.Optional[Int] = None,
    refreshRateLimitTimeWindowMs: Input.Optional[Int] = None,
    rolesKey: Input.Optional[String] = None,
    scope: Input.Optional[String] = None,
    subjectKey: Input.Optional[String] = None
  )(using Context): OpenSearchOpensearchUserConfigOpenidArgs =
    new OpenSearchOpensearchUserConfigOpenidArgs(
      clientId = clientId.asOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false),
      connectUrl = connectUrl.asOutput(isSecret = false),
      enabled = enabled.asOptionOutput(isSecret = false),
      header = header.asOptionOutput(isSecret = false),
      jwtHeader = jwtHeader.asOptionOutput(isSecret = false),
      jwtUrlParameter = jwtUrlParameter.asOptionOutput(isSecret = false),
      refreshRateLimitCount = refreshRateLimitCount.asOptionOutput(isSecret = false),
      refreshRateLimitTimeWindowMs = refreshRateLimitTimeWindowMs.asOptionOutput(isSecret = false),
      rolesKey = rolesKey.asOptionOutput(isSecret = false),
      scope = scope.asOptionOutput(isSecret = false),
      subjectKey = subjectKey.asOptionOutput(isSecret = false)
    )
