package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchUserConfigOpensearchDashboardsArgs private(
  enabled: Output[Option[Boolean]],
  maxOldSpaceSize: Output[Option[Int]],
  opensearchRequestTimeout: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchUserConfigOpensearchDashboardsArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    maxOldSpaceSize: Input.Optional[Int] = None,
    opensearchRequestTimeout: Input.Optional[Int] = None
  )(using Context): OpenSearchOpensearchUserConfigOpensearchDashboardsArgs =
    new OpenSearchOpensearchUserConfigOpensearchDashboardsArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      maxOldSpaceSize = maxOldSpaceSize.asOptionOutput(isSecret = false),
      opensearchRequestTimeout = opensearchRequestTimeout.asOptionOutput(isSecret = false)
    )
