package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchUserConfigPrivatelinkAccessArgs private(
  opensearch: Output[Option[Boolean]],
  opensearchDashboards: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchUserConfigPrivatelinkAccessArgs:
  def apply(
    opensearch: Input.Optional[Boolean] = None,
    opensearchDashboards: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): OpenSearchOpensearchUserConfigPrivatelinkAccessArgs =
    new OpenSearchOpensearchUserConfigPrivatelinkAccessArgs(
      opensearch = opensearch.asOptionOutput(isSecret = false),
      opensearchDashboards = opensearchDashboards.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
