package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchUserConfigPublicAccessArgs private(
  opensearch: Output[Option[Boolean]],
  opensearchDashboards: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchUserConfigPublicAccessArgs:
  def apply(
    opensearch: Input.Optional[Boolean] = None,
    opensearchDashboards: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): OpenSearchOpensearchUserConfigPublicAccessArgs =
    new OpenSearchOpensearchUserConfigPublicAccessArgs(
      opensearch = opensearch.asOptionOutput(isSecret = false),
      opensearchDashboards = opensearchDashboards.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
