package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OpenSearchOpensearchUserConfigSamlArgs private(
  enabled: Output[Boolean],
  idpEntityId: Output[String],
  idpMetadataUrl: Output[String],
  idpPemtrustedcasContent: Output[Option[String]],
  rolesKey: Output[Option[String]],
  spEntityId: Output[String],
  subjectKey: Output[Option[String]]
) derives Encoder, ArgsEncoder

object OpenSearchOpensearchUserConfigSamlArgs:
  def apply(
    enabled: Input[Boolean],
    idpEntityId: Input[String],
    idpMetadataUrl: Input[String],
    idpPemtrustedcasContent: Input.Optional[String] = None,
    rolesKey: Input.Optional[String] = None,
    spEntityId: Input[String],
    subjectKey: Input.Optional[String] = None
  )(using Context): OpenSearchOpensearchUserConfigSamlArgs =
    new OpenSearchOpensearchUserConfigSamlArgs(
      enabled = enabled.asOutput(isSecret = false),
      idpEntityId = idpEntityId.asOutput(isSecret = false),
      idpMetadataUrl = idpMetadataUrl.asOutput(isSecret = false),
      idpPemtrustedcasContent = idpPemtrustedcasContent.asOptionOutput(isSecret = false),
      rolesKey = rolesKey.asOptionOutput(isSecret = false),
      spEntityId = spEntityId.asOutput(isSecret = false),
      subjectKey = subjectKey.asOptionOutput(isSecret = false)
    )
