package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class OrganizationTimeoutsArgs private(
  create: Output[Option[String]],
  delete: Output[Option[String]],
  read: Output[Option[String]],
  update: Output[Option[String]]
) derives Encoder, ArgsEncoder

object OrganizationTimeoutsArgs:
  def apply(
    create: Input.Optional[String] = None,
    delete: Input.Optional[String] = None,
    read: Input.Optional[String] = None,
    update: Input.Optional[String] = None
  )(using Context): OrganizationTimeoutsArgs =
    new OrganizationTimeoutsArgs(
      create = create.asOptionOutput(isSecret = false),
      delete = delete.asOptionOutput(isSecret = false),
      read = read.asOptionOutput(isSecret = false),
      update = update.asOptionOutput(isSecret = false)
    )
