package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PgPgArgs private(
  dbname: Output[Option[String]],
  host: Output[Option[String]],
  maxConnections: Output[Option[Int]],
  password: Output[Option[String]],
  port: Output[Option[Int]],
  replicaUri: Output[Option[String]],
  sslmode: Output[Option[String]],
  uri: Output[Option[String]],
  user: Output[Option[String]]
) derives Encoder, ArgsEncoder

object PgPgArgs:
  def apply(
    dbname: Input.Optional[String] = None,
    host: Input.Optional[String] = None,
    maxConnections: Input.Optional[Int] = None,
    password: Input.Optional[String] = None,
    port: Input.Optional[Int] = None,
    replicaUri: Input.Optional[String] = None,
    sslmode: Input.Optional[String] = None,
    uri: Input.Optional[String] = None,
    user: Input.Optional[String] = None
  )(using Context): PgPgArgs =
    new PgPgArgs(
      dbname = dbname.asOptionOutput(isSecret = false),
      host = host.asOptionOutput(isSecret = false),
      maxConnections = maxConnections.asOptionOutput(isSecret = false),
      password = password.asOptionOutput(isSecret = true),
      port = port.asOptionOutput(isSecret = false),
      replicaUri = replicaUri.asOptionOutput(isSecret = true),
      sslmode = sslmode.asOptionOutput(isSecret = false),
      uri = uri.asOptionOutput(isSecret = true),
      user = user.asOptionOutput(isSecret = false)
    )
