package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PgPgUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  adminPassword: Output[Option[String]],
  adminUsername: Output[Option[String]],
  backupHour: Output[Option[Int]],
  backupMinute: Output[Option[Int]],
  enableIpv6: Output[Option[Boolean]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.PgPgUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  migration: Output[Option[besom.api.aiven.inputs.PgPgUserConfigMigrationArgs]],
  pg: Output[Option[besom.api.aiven.inputs.PgPgUserConfigPgArgs]],
  pgReadReplica: Output[Option[Boolean]],
  pgServiceToForkFrom: Output[Option[String]],
  pgStatMonitorEnable: Output[Option[Boolean]],
  pgVersion: Output[Option[String]],
  pgbouncer: Output[Option[besom.api.aiven.inputs.PgPgUserConfigPgbouncerArgs]],
  pglookout: Output[Option[besom.api.aiven.inputs.PgPgUserConfigPglookoutArgs]],
  privateAccess: Output[Option[besom.api.aiven.inputs.PgPgUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.PgPgUserConfigPrivatelinkAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.PgPgUserConfigPublicAccessArgs]],
  recoveryTargetTime: Output[Option[String]],
  serviceToForkFrom: Output[Option[String]],
  sharedBuffersPercentage: Output[Option[Double]],
  staticIps: Output[Option[Boolean]],
  synchronousReplication: Output[Option[String]],
  timescaledb: Output[Option[besom.api.aiven.inputs.PgPgUserConfigTimescaledbArgs]],
  variant: Output[Option[String]],
  workMem: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object PgPgUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    adminPassword: Input.Optional[String] = None,
    adminUsername: Input.Optional[String] = None,
    backupHour: Input.Optional[Int] = None,
    backupMinute: Input.Optional[Int] = None,
    enableIpv6: Input.Optional[Boolean] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.PgPgUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    migration: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigMigrationArgs] = None,
    pg: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigPgArgs] = None,
    pgReadReplica: Input.Optional[Boolean] = None,
    pgServiceToForkFrom: Input.Optional[String] = None,
    pgStatMonitorEnable: Input.Optional[Boolean] = None,
    pgVersion: Input.Optional[String] = None,
    pgbouncer: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigPgbouncerArgs] = None,
    pglookout: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigPglookoutArgs] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigPrivatelinkAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigPublicAccessArgs] = None,
    recoveryTargetTime: Input.Optional[String] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    sharedBuffersPercentage: Input.Optional[Double] = None,
    staticIps: Input.Optional[Boolean] = None,
    synchronousReplication: Input.Optional[String] = None,
    timescaledb: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigTimescaledbArgs] = None,
    variant: Input.Optional[String] = None,
    workMem: Input.Optional[Int] = None
  )(using Context): PgPgUserConfigArgs =
    new PgPgUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      adminPassword = adminPassword.asOptionOutput(isSecret = true),
      adminUsername = adminUsername.asOptionOutput(isSecret = false),
      backupHour = backupHour.asOptionOutput(isSecret = false),
      backupMinute = backupMinute.asOptionOutput(isSecret = false),
      enableIpv6 = enableIpv6.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      migration = migration.asOptionOutput(isSecret = false),
      pg = pg.asOptionOutput(isSecret = false),
      pgReadReplica = pgReadReplica.asOptionOutput(isSecret = false),
      pgServiceToForkFrom = pgServiceToForkFrom.asOptionOutput(isSecret = false),
      pgStatMonitorEnable = pgStatMonitorEnable.asOptionOutput(isSecret = false),
      pgVersion = pgVersion.asOptionOutput(isSecret = false),
      pgbouncer = pgbouncer.asOptionOutput(isSecret = false),
      pglookout = pglookout.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      recoveryTargetTime = recoveryTargetTime.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      sharedBuffersPercentage = sharedBuffersPercentage.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      synchronousReplication = synchronousReplication.asOptionOutput(isSecret = false),
      timescaledb = timescaledb.asOptionOutput(isSecret = false),
      variant = variant.asOptionOutput(isSecret = false),
      workMem = workMem.asOptionOutput(isSecret = false)
    )
