package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class PgPgUserConfigPgbouncerArgs private(
  autodbIdleTimeout: Output[Option[Int]],
  autodbMaxDbConnections: Output[Option[Int]],
  autodbPoolMode: Output[Option[String]],
  autodbPoolSize: Output[Option[Int]],
  ignoreStartupParameters: Output[Option[scala.collection.immutable.List[String]]],
  minPoolSize: Output[Option[Int]],
  serverIdleTimeout: Output[Option[Int]],
  serverLifetime: Output[Option[Int]],
  serverResetQueryAlways: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object PgPgUserConfigPgbouncerArgs:
  def apply(
    autodbIdleTimeout: Input.Optional[Int] = None,
    autodbMaxDbConnections: Input.Optional[Int] = None,
    autodbPoolMode: Input.Optional[String] = None,
    autodbPoolSize: Input.Optional[Int] = None,
    ignoreStartupParameters: Input.Optional[List[Input[String]]] = None,
    minPoolSize: Input.Optional[Int] = None,
    serverIdleTimeout: Input.Optional[Int] = None,
    serverLifetime: Input.Optional[Int] = None,
    serverResetQueryAlways: Input.Optional[Boolean] = None
  )(using Context): PgPgUserConfigPgbouncerArgs =
    new PgPgUserConfigPgbouncerArgs(
      autodbIdleTimeout = autodbIdleTimeout.asOptionOutput(isSecret = false),
      autodbMaxDbConnections = autodbMaxDbConnections.asOptionOutput(isSecret = false),
      autodbPoolMode = autodbPoolMode.asOptionOutput(isSecret = false),
      autodbPoolSize = autodbPoolSize.asOptionOutput(isSecret = false),
      ignoreStartupParameters = ignoreStartupParameters.asOptionOutput(isSecret = false),
      minPoolSize = minPoolSize.asOptionOutput(isSecret = false),
      serverIdleTimeout = serverIdleTimeout.asOptionOutput(isSecret = false),
      serverLifetime = serverLifetime.asOptionOutput(isSecret = false),
      serverResetQueryAlways = serverResetQueryAlways.asOptionOutput(isSecret = false)
    )
